% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmPen.R
\name{LambdaSeq}
\alias{LambdaSeq}
\title{Calculation of Penalty Parameter Sequence (Lambda Sequence)}
\usage{
LambdaSeq(
  X,
  y,
  family,
  alpha = 1,
  lambda.min = NULL,
  nlambda = 10,
  penalty.factor = NULL
)
}
\arguments{
\item{X}{matrix of standardized fixed effects (see \code{std} function in \code{ncvreg} 
documenation). X should not include intercept.}

\item{y}{numeric vector of response values}

\item{family}{a description of the error distribution and link function to be used in the model. 
Currently, the \code{glmmPen} algorithm allows the binomial, gaussian, and poisson families
with canonical links only.}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions 
from the MCP/SCAD/lasso penalty and the ridge, or L2, penalty. \code{alpha=1} is equivalent to 
the MCP/SCAD/lasso penalty, while \code{alpha=0} is equivalent to ridge regression. However,
\code{alpha=0} is not supported; \code{alpha} may be arbitrarily small, but not exactly zero}

\item{lambda.min}{numeric fraction between 0 and 1. The sequence of the lambda penalty parameters
ranges from the maximum lambda where all fixed and random effects are penalized to 0 and 
a minimum lambda value, which equals a small fraction of the maximum lambda. The parameter 
\code{lambda.min} specifies this fraction. Default value is set to \code{NULL}, which
automatically selects \code{lambda.min} to equal 0.01 when p <= 10 and 0.05 when p > 10.}

\item{nlambda}{positive integer specifying number of penalty parameters (lambda) with 
which to fit a model.}

\item{penalty.factor}{an optional numeric vector equal to the \code{fixef_noPen} argument
in \code{\link{glmmPen}}}
}
\value{
numeric sequence of penalty parameters of length \code{nlambda} ranging from the
minimum penalty parameter (first element) equal to fraction \code{lambda.min} multiplied by the 
maximum penalty parameter to the maximum penalty parameter (last element)
}
\description{
Calculates the sequence of penalty parameters used in the model selection procedure.
This function calls functions from package \code{ncvreg}.
}
