% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mvn_ll}
\alias{mvn_ll}
\title{Multivariate normal log likelihood}
\usage{
mvn_ll(cov, data, eff_range, gamma, u)
}
\arguments{
\item{cov}{An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.}

\item{data}{Vector of data. Created by flattening the matrices in column-major order of the data used in each block.}

\item{eff_range}{Vector of values with the effective range parameters of the covariance functions, where required.}

\item{gamma}{Vector specifying the values of the covariance function parameters}

\item{u}{Matrix (or vector) of observed values}
}
\value{
Scalar value 
## small example with simulated random effects
## first, create data and model object with parameters
df <- nelder(~(j(10) * t(3)) > i(5))
des <- ModelMCML$new(
 covariance = list(
  formula =  ~(1|gr(j)*ar1(t)),
  parameters = c(0.25,0.7)
),
mean = list(
  formula = ~factor(t)-1,
  parameters = rnorm(3)
),
data=df,
family=gaussian()
)
## get covariance definition matrix
ddata <- des$covariance$get_D_data()
## simulate some values of the random effects
## first, we need to extract the Cholesky decomposition of the covariance matrix D
L <- des$covariance$get_chol_D()
## generate samples using HMC
mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
   L = as.matrix(L),
   X = as.matrix(des$mean_function$X),
   y = as.vector(y),
   beta = des$mean_function$parameters,
   var_par = 1,
   family = des$mean_function$family[[1]],
   link = des$mean_function$family[[2]],
   warmup = 250, 
   nsamp = 250,
   lambda = 5,
   maxsteps = 100,
   trace=1,
   target_accept = 0.95)
## calculate the log likelihood for the simulated random effects
mvn_ll(cov=ddata$cov,
  data=ddata$data,
  eff_range = rep(0,30),
  gamma = c(0.25,0.7),
  u = mat)
}
\description{
Calculates the log likelihood of the multivariate normal distribution using `glmmr` covariance representation.
}
