% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{races}
\alias{races}
\title{Hill races in Scotland}
\format{
A data frame with 35 rows and 4 variables:
\describe{
  \item{race}{a character vector giving the names of the races.}
  \item{distance}{a numeric vector giving the distance, in miles, of the races.}
  \item{cclimb}{a numeric vector giving the cumulative climb, in thousands of feet, of the races.}
  \item{rtime}{a numeric vector giving the record time, in minutes, of the races.}
}
}
\source{
\url{http://users.stat.ufl.edu/~aa/glm/data/}
}
\usage{
data(races)
}
\description{
Each year the Scottish Hill Runners Association publishes a list of
hill races in Scotland for the year. These data consist of record time,
distance, and cumulative climb of 35 of those races. The aim of the statistical
analysis of these data is to explain the differences between the record time of
the races using their differences on distance and cumulative climb. See Agresti (2015, page 62).
}
\examples{
races2 <- within(races,cli <- cut(cclimb, include.lowest=TRUE,
                                  breaks=quantile(cclimb, probs=c(0:2)/2),
                                  labels=c("low","high")))
with(races2,{
    plot(log(distance), log(rtime),
         col=apply(as.matrix(cli),1,function(x) switch(x,"low"="red","high"="blue")),
         pch=apply(as.matrix(cli),1,function(x) switch(x,"low"=15,"high"=16)))
    legend(0.5, 5.5, legend=c("low","high"), title="Cumulative climb",
           col=c("red","blue"), pch=c(15,16), bty="n", cex=0.75,
           title.adj=0.4, y.intersp=0.5, x.intersp=0.3)
})
}
\references{
Agresti A. (2015) \emph{Foundations of Linear and Generalized Linear Models}.
John Wiley & Sons, New Jersey.
}
\keyword{datasets}
