% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{residuals.glmgee}
\alias{residuals.glmgee}
\title{Residuals for Generalized Estimating Equations}
\usage{
\method{residuals}{glmgee}(
  object,
  ...,
  type = c("mahalanobis", "pearson", "deviance"),
  plot.it = TRUE,
  identify
)
}
\arguments{
\item{object}{a object of the class glmgee obtained from the fit of a generalized estimating equation.}

\item{...}{further arguments passed to or from other methods}

\item{type}{an (optional) character string giving the type of residuals which should be returned. The available options are: (1) "pearson"; (2) "deviance";  (3) the distance between the observed response vector and the fitted mean vector using a metric based on the product between the cluster size and fitted variance-covariance matrix ("mahalanobis"). By default, \code{type} is set to be "mahalanobis".}

\item{plot.it}{an (optional) logical switch indicating if a plot of the residuals is required. By default, \code{plot.it} is set to be TRUE.}

\item{identify}{an (optional) integer value indicating the number of individuals/clusters to identify on the plot of residuals. This is only appropriate when \code{plot.it=TRUE}.}
}
\value{
A vector with the observed residuals type \code{type}.
}
\description{
Calculates residuals for a fitted generalized estimating equation.
}
\examples{
mod <- size ~ poly(days,4) + treat
fit <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="AR-1")
residuals(fit, type="mahalanobis", col="red", pch=20, col.lab="blue",
          col.axis="blue", col.main="black", family="mono", cex=0.8)
}
