% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{stepCriterion.overglm}
\alias{stepCriterion.overglm}
\title{Variable selection in Negative Binomial and Beta-Binomial Regression Models}
\usage{
\method{stepCriterion}{overglm}(
  model,
  criterion = c("bic", "aic", "p-value"),
  test = c("wald", "score", "lr", "gradient"),
  direction = c("forward", "backward"),
  levels = c(0.05, 0.05),
  trace = TRUE,
  scope,
  ...
)
}
\arguments{
\item{model}{an object of the class overglm which is obtained from the fit of a negative binomial or beta-binomial regression model.}

\item{criterion}{an (optional) character string indicating the criterion which should be used to compare the candidate models. The available options are: AIC ("aic"), BIC ("bic"), and \emph{p}-value of the \code{test} test ("p-value"). By default, \code{criterion} is set to be "bic".}

\item{test}{an (optional) character string indicating the statistical test which should be used to compare nested models. The available options are: Wald ("wald"), Rao's score ("score"), likelihood-ratio ("lr") and gradient ("gradient") tests. By default, \code{test} is set to be "wald".}

\item{direction}{an (optional) character string indicating the type of procedure which should be used. The available options are: hybrid backward stepwise ("backward") and hybrid forward stepwise ("forward"). By default, \code{direction} is set to be "forward".}

\item{levels}{an (optional) two-dimensional vector of values in the interval \eqn{(0,1)} indicating the levels at which the variables should in and out from the model. This is only appropiate if \code{criterion}="p-value". By default, \code{levels} is set to be \code{c(0.05,0.05)}.}

\item{trace}{an (optional) logical switch indicating if should the stepwise reports be printed. By default, \code{trace} is set to be TRUE.}

\item{scope}{an (optional) list containing components \code{lower} and \code{upper}, both formula-type objects, indicating the range of models which should be examined in the stepwise search. By default, \code{lower} is a model with no predictors and \code{upper} is the linear predictor of the model in \code{model}.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the penalty in the AIC, which by default is set to be 2.}
}
\value{
A list which contains the following objects:
\itemize{
\item{\code{initial}:}{ a character string indicating the linear predictor of the "initial model".}
\item{\code{direction}:}{ a character string indicating the type of procedure which was used.}
\item{\code{criterion}:}{ a character string indicating the criterion used to compare the candidate models.}
\item{\code{final}:}{ a character string indicating the linear predictor of the "final model".}
}
}
\description{
Performs variable selection in negative binomial and beta-binomial regression models using hybrid versions of forward stepwise and backward stepwise.
}
\examples{
fit <- overglm(infections ~ frequency + location + age + gender, family="nb1(log)", data=swimmers)
stepCriterion(fit,direction="forward",criterion="p-value",test="lr")
stepCriterion(fit,direction="backward",criterion="p-value",test="lr")
stepCriterion(fit,direction="forward",criterion="bic")
stepCriterion(fit,direction="backward",criterion="bic")
}
\references{
James G., Witten D., Hastie T. and Tibshirani R. (2013, page 210) An Introduction to Statistical Learning with Applications in R, Springer, New York.
}
\seealso{
\link{stepCriterion.lm}, \link{stepCriterion.glm}, \link{stepCriterion.glmgee}
}
