% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shelflife}
\alias{shelflife}
\title{Shelf life of a photographic developer}
\format{
A data frame with 21 rows and 3 variables:
\describe{
  \item{Time}{ a numeric vector giving the shelf life, in hours.}
  \item{Temp}{ a factor giving the temperature, in degrees celsius.}
  \item{Dmax}{ a numeric vector giving the maximum density.}
}
}
\usage{
data(shelflife)
}
\description{
These data arise from an experiment using accelerated
life testing to determine the estimated shelf life of a photographic
developer. The maximum density as well as the temperature seem to
be good indicators of overall developer/film performance.
}
\examples{
data(shelflife)
dev.new()
with(shelflife,plot(Dmax, Time, pch=16, col=as.numeric(Temp)))
legend("topright", legend=c("72C","82C","92C"), col=c(1:3), pch=16,
       title="Temperature", bty="n")

}
\references{
Chapman, R.E. (1997) Degradation study of a photographic developer to determine shelf life,
\emph{Quality Engineering} 10:1, 137-140.
}
\keyword{datasets}
