% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_keywords.r
\name{add_synonym}
\alias{add_synonym}
\title{Add synonyms for object keywords}
\usage{
add_synonym(keyword, synonym)
}
\arguments{
\item{keyword}{Keyword of type \code{character} and length 1 for which the
synonyms are added.}

\item{synonym}{Synonym of type \code{character}.}
}
\value{
Message that the synonym has been added successfully. Synonym data is
written to table \emph{keyword_synonyms}.
}
\description{
The function allows to add synonyms for object keywords. Sometimes, objects
of interest can be searched with different keywords on Google e.g., FC Bayern
for Bayern Munich. Search scores for keywords that are added as synonyms are
aggregated when running \code{compute_score}. The function allows to add
synonyms for a single keyword at a time.
\emph{Note}: To avoid trailing spaces \code{stringr::str_squish} is automatically
applied to all keywords and synonyms.
}
\examples{
\dontrun{
add_synonym(
  keyword = "fc bayern",
  synonym = "bayern munich"
)
}

}
\seealso{
\itemize{
\item \code{\link[=compute_score]{compute_score()}}
\item \code{\link[stringr:str_trim]{stringr::str_squish()}}
}
}
