% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloss.R
\name{new_gloss_data}
\alias{new_gloss_data}
\title{gloss_data class}
\usage{
new_gloss_data(
  gloss_lines,
  source = NULL,
  translation = NULL,
  label = NULL,
  trans_quotes = getOption("glossr.trans.quotes", "\\"")
)
}
\arguments{
\item{gloss_lines}{Lines for glossing, as a list}

\item{source}{(Optional) Source of example}

\item{translation}{(Optional) Free translation}

\item{label}{(Optional) Example label}

\item{trans_quotes}{(Optional) Quotes to surround the free translation with.}
}
\value{
Object of class \code{gloss_data}
}
\description{
Based on a character vectors and up to three label arguments,
create an object where those arguments are attributes.
These are:
\describe{
   \item{source}{Where the text comes from. This will be printed
   in the first line of the example, without word alignment.}
   \item{translation}{Free translation. This will be printed as the
   last line of the example, without word alignment and in quotation
   marks if so desired.}
   \item{label}{Named label of the example, for cross-references.}
   \item{lengths}{This is computed within the function, not provider, and
   it's the number of items identified in each gloss line.}
}
This function is mostly for internal use, but may be useful for debugging or
checking the output of specific calls. Normally, it's best to use
\code{\link{as_gloss}} or \code{\link{gloss_df}}.
Note that, unlike \code{\link{as_gloss}}, \code{new_gloss_data} requires a list
of gloss lines.
}
