% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottospace.R
\name{glottospace}
\alias{glottospace}
\title{Make glottodata spatial and generate language polygons from points.}
\usage{
glottospace(glottodata, method = NULL, radius = NULL)
}
\arguments{
\item{glottodata}{A glottodata table, or list of a glottodata table and metadata table(s)}

\item{method}{Interpolation method, either "buffer" or "voronoi" (synonymous with "thiessen")}

\item{radius}{In case interpolation method "buffer", the radius in km.}
}
\value{
A spatial version of glottodata. In case glottodata has metadata, only glottodata
 will be converted to spatial (but all metadata tables are kept).
 Object returned as sf object, or a list of which the first element is an sf object, depending on the input.
}
\description{
This function takes glottodata (either with or without metadata) and turns it into spatial points or polygons.
}
\examples{
glottodata <- glottoget("demodata", meta = TRUE)
\donttest{
glottospacedata <- glottospace(glottodata, method = "voronoi")
}
}
