% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{glue}
\alias{glue}
\alias{glue_data}
\alias{to_data}
\alias{glue}
\alias{to}
\title{Format and interpolate a string}
\usage{
glue_data(.x, ..., .sep = "", .envir = parent.frame())

to_data(.x, ..., .sep = "", .envir = parent.frame())

glue(..., .sep = "", .envir = parent.frame())

to(..., .sep = "", .envir = parent.frame())
}
\arguments{
\item{.x}{An environment, list or data frame.}

\item{...}{String(s) to format, multiple inputs are concatenated together before formatting.}

\item{.sep}{Separator used to separate elements.}

\item{.envir}{Environment to evaluate each expression in. Expressions are
evaluated from left to right.}
}
\description{
Expressions enclosed by braces will be evaluated as R code. Single braces
can be inserted by doubling them. The inputs are not vectorized.
}
\examples{
name <- "Fred"
age <- 50
anniversary <- as.Date("1991-10-12")
glue('My name is {name},',
  'my age next year is {age + 1},',
  'my anniversary is {format(anniversary, "\%A, \%B \%d, \%Y")}.')

# single braces can be inserted by doubling them
glue("My name is {name}, not {{name}}.")

# Named arguments can also be supplied
glue('My name is {name},',
  ' my age next year is {age + 1},',
  ' my anniversary is {format(anniversary, "\%A, \%B \%d, \%Y")}.',
  name = "Joe",
  age = 40,
  anniversary = as.Date("2001-10-12"))

# `glue_data()` is useful in magrittr pipes
library(magrittr)
mtcars \%>\% glue_data("{rownames(.)} has {hp} hp")
}
\seealso{
\url{https://www.python.org/dev/peps/pep-0498/} and
\url{https://www.python.org/dev/peps/pep-0257} upon which this is based.
}
