% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-quote.R
\name{md_quote}
\alias{md_quote}
\title{Markdown block quotes}
\usage{
md_quote(x)
}
\arguments{
\item{x}{The character vector of quotes.}
}
\value{
A character vector with a greater-than symbol (\code{>}) prepended to each
element.
}
\description{
Take a character vector and prepend each element in a greater-than symbol to
create a glue vector of block quote markdown text. This inline is rendered as
a \code{<blockquote>} HTML tag.
}
\details{
A block quote marker consists of 0-3 spaces of initial indent, plus (a) the
character \code{>} together with a following space, or (b) a single character \code{>}
not followed by a space.

The following rules define block quotes:
\enumerate{
\item \strong{Basic case.} If a string of lines \emph{Ls} constitute a sequence of blocks
\emph{Bs}, then the result of prepending a block quote marker to the beginning of
each line in \emph{Ls} is a block quote containing \emph{Bs}.
\item \strong{Laziness.} If a string of lines \emph{Ls} constitute a block quote with
contents \emph{Bs}, then the result of deleting the initial block quote marker
from one or more lines in which the next non-whitespace character after the
block quote marker is paragraph continuation text is a block quote with \emph{Bs}
as its content. Paragraph continuation text is text that will be parsed as
part of the content of a paragraph, but does not occur at the beginning of
the paragraph.
\item \strong{Consecutiveness.} A document cannot contain two block quotes in a row
unless there is a blank line between them.
}

Nothing else counts as a block quote.
}
\examples{
md_quote("Give me liberty, or give me death!")
md_quote(stringr::sentences[1:3])
}
\seealso{
Other container block functions: \code{\link{md_bullet}},
  \code{\link{md_define}}, \code{\link{md_list}},
  \code{\link{md_order}}, \code{\link{md_task}}
}
\concept{container block functions}
