% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialMethodParameters.R
\name{DSpars}
\alias{DSpars}
\alias{DirectSamplingParameters}
\title{Create a parameter set specifying a direct sampling algorithm}
\usage{
DSpars(nsim = 1, scanFraction = 0.25, patternSize = 10, gof = 0.05, ...)
}
\arguments{
\item{nsim}{number of realisations desired (attention: current algorithm is slow, start with small values!)}

\item{scanFraction}{maximum fraction of the training image to be scanned on each iteration}

\item{patternSize}{number of observations used for conditioning the simulation}

\item{gof}{maximum acceptance discrepance between a data event in the training image and the conditioning data event}

\item{...}{further parameters, not used}
}
\value{
an S3-list of class "gmDirectSamplingParameters" containing the six elements given as arguments
to the function. This is just a compact way to provide further functions such as \link{predict_gmSpatialModel}
with appropriate triggers for choosing a prediction method or another, in this case for triggering
direct sampling.
}
\description{
Create a parameter set describing a direct sampling algorithm to multipoint simulation.
All parameters except \code{nsim} are optional, as they have default values reasonable
according to experience.
}
\examples{
(dsp = DSpars(nsim=100, scanFraction=75, patternSize=6, gof=0.05))
## then run predict(..., pars=dsp)
}
