% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm-auth.R
\name{gm_scopes}
\alias{gm_scopes}
\alias{gm_auth}
\title{Authorize bigrquery}
\usage{
gm_scopes()

gm_auth(email = gm_default_email(), path = NULL, scopes = "full",
  cache = gargle::gargle_oauth_cache(),
  use_oob = gargle::gargle_oob_default(), token = NULL)
}
\arguments{
\item{email}{Optional. Allows user to target a specific Google identity. If
specified, this is used for token lookup, i.e. to determine if a suitable
token is already available in the cache. If no such token is found, \code{email}
is used to pre-select the targetted Google identity in the OAuth chooser.
Note, however, that the email associated with a token when it's cached is
always determined from the token itself, never from this argument. Use \code{NA}
or \code{FALSE} to match nothing and force the OAuth dance in the browser. Use
\code{TRUE} to allow email auto-discovery, if exactly one matching token is
found in the cache. Defaults to the option named "gargle_oauth_email",
retrieved by \code{\link[gargle:gargle_oauth_email]{gargle::gargle_oauth_email()}}.}

\item{path}{JSON identifying the service account, in one of the forms
supported for the \code{txt} argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a
file path or JSON string).}

\item{scopes}{One or more gmail API scope to use, one of 'labels', 'send',
'readonly', 'compose', 'insert', 'modify', 'metadata', 'settings_basic',
'settings_sharing' or 'full' (default: 'full'). See
\url{https://developers.google.com/gmail/api/auth/scopes} for details on the
permissions for each scope. and \code{gm_scopes()} to return a vector of the
available scopes.}

\item{cache}{Specifies the OAuth token cache. Defaults to the option named
"gargle_oauth_cache", retrieved via \code{\link[gargle:gargle_oauth_cache]{gargle::gargle_oauth_cache()}}.}

\item{use_oob}{Whether to prefer "out of band" authentication. Defaults to
the option named "gargle_oob_default", retrieved via
\code{\link[gargle:gargle_oob_default]{gargle::gargle_oob_default()}}.}

\item{token}{A token with class \link[httr:Token-class]{Token2.0} or an object of
httr's class \code{request}, i.e. a token that has been prepared with
\code{\link[httr:config]{httr::config()}} and has a \link[httr:Token-class]{Token2.0} in the
\code{auth_token} component.}
}
\description{
Authorize gmailr to view and manage your Gmail projects. This function is a
wrapper around \code{\link[gargle:token_fetch]{gargle::token_fetch()}}.

By default, you are directed to a web browser, asked to sign in to your
Google account, and to grant gmailr permission to operate on your
behalf with Google Gmail. By default, these user credentials are cached in a
folder below your home directory, \code{~/.R/gargle/gargle-oauth}, from where
they can be automatically refreshed, as necessary. Storage at the user
level means the same token can be used across multiple projects and
tokens are less likely to be synced to the cloud by accident.
}
\details{
Most users, most of the time, do not need to call \code{gm_auth()}
explicitly -- it is triggered by the first action that requires
authorization. Even when called, the default arguments often suffice.
However, when necessary, this function allows the user to explicitly:
\itemize{
\item Declare which Google identity to use, via an email address. If there
are multiple cached tokens, this can clarify which one to use. It can
also force gmailr to switch from one identity to another. If
there's no cached token for the email, this triggers a return to the
browser to choose the identity and give consent.
\item Use a service account token.
\item Bring their own \link[httr:Token-class]{Token2.0}.
\item Specify non-default behavior re: token caching and out-of-bound
authentication.
}

For details on the many ways to find a token, see
\code{\link[gargle:token_fetch]{gargle::token_fetch()}}. For deeper control over auth, use
\code{\link[=gm_auth_configure]{gm_auth_configure()}} to bring your own OAuth app or API key.
}
\examples{
\dontrun{
## load/refresh existing credentials, if available
## otherwise, go to browser for authentication and authorization
gm_auth()

## force use of a token associated with a specific email
gm_auth(email = "jim@example.com")

## force a menu where you can choose from existing tokens or
## choose to get a new one
gm_auth(email = NA)

## use a 'read only' scope, so it's impossible to change data
gm_auth(
  scopes = "https://www.googleapis.com/auth/gmail.readonly"
)

## use a service account token
gm_auth(path = "foofy-83ee9e7c9c48.json")
}
}
\seealso{
Other auth functions: \code{\link{gm_auth_configure}},
  \code{\link{gm_deauth}}
}
\concept{auth functions}
