% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag.R
\name{dag-constrained correlation matrices}
\alias{dag-constrained correlation matrices}
\alias{chol_mh}
\alias{chol_iid}
\title{Simulation of correlation matrices}
\usage{
chol_mh(N = 1, p = 3, d = 1, dag = NULL, ...)

chol_iid(N = 1, p = 3, d = 1, dag = NULL)
}
\arguments{
\item{N}{Number of samples.}

\item{p}{Matrix dimension. Ignored if \code{dag} is provided.}

\item{d}{Number in \verb{[0,1]}, the proportion of non-zero
entries in the Cholesky factor of the sampled matrices.
Ignored if \code{dag} is provided.}

\item{dag}{An
igraph acyclic
digraph specifying the zero pattern in the upper Cholesky
factor of the sampled matrices. Nodes must be in ancestral
order, with the first one having no parents.}

\item{...}{Additional parameters for \code{\link[=mh_u]{mh_u()}}.}
}
\value{
A three-dimensional array of length \verb{p x p x N}.
}
\description{
Sample correlation matrices, possibly with a zero pattern in its Cholesky
decomposition constrained by an acyclic digraph.
}
\details{
Function \code{\link[=chol_mh]{chol_mh()}} uses the method described in
Córdoba et al.  (2018) and implemented in \code{\link[=mh_u]{mh_u()}}, based
on a Metropolis-Hastings algorithm over the upper Cholesky
factorization.

The entries in the upper Cholesky factor are sampled i.i.d. by
function \code{\link[=chol_iid]{chol_iid()}}, following Kalisch and Buhlmann (2007).
}
\examples{
## Cholesky sampling via Metropolis-Hastings
# Generate a full matrix (default behaviour)
chol_mh()

# Generate a matrix with a percentage of zeros
chol_mh(d = 0.5)

# Generate a random acyclic digraph structure
dag <- rgraph(p = 3, d = 0.5, dag = TRUE)
igraph::print.igraph(dag)

# Generate a matrix complying with the predefined zero pattern
chol_mh(dag = dag)
## Cholesky sampling via i.i.d. Cholesky factor
# Generate a full matrix (default behaviour)
chol_iid()

# Generate a matrix with a percentage of zeros
chol_iid(d = 0.5)

# Generate a matrix complying with the predefined zero pattern
igraph::print.igraph(dag)
chol_iid(dag = dag)
}
\references{
Córdoba I., Varando G., Bielza C., Larrañaga P. A fast
Metropolis-Hastings method for generating random correlation matrices. \emph{Lecture Notes in
Computer Science} (IDEAL 2018), vol 11314, pp. 117-124, 2018.

Kalisch, M., Buhlmann, P. Estimating high-dimensional directed
acyclic graphs with the PC-algorithm, \emph{Journal of Machine Learning Research},
8:613-636, 2007.
}
