% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfixef.R
\name{fixef.joint}
\alias{fixef.joint}
\title{Extract fixed effects from a \code{joint} object.}
\usage{
\method{fixef}{joint}(object, what = c("long", "surv"), ...)
}
\arguments{
\item{object}{a joint model fit by the \code{joint} function.}

\item{what}{character string. Should the \code{"long"}itudinal process(es) be extracted,
or the \code{"surv"}ival ones?}

\item{...}{additional arguments (none used).}
}
\value{
A vector containing requested fixed effects.
}
\description{
Extract fixed effects from a \code{joint} object.
}
\examples{
# Univariate fit on PBC data -------------------------------------------
data(PBC)

# Subset data and remove NAs
PBC <- subset(PBC, select = c('id', 'survtime', 'status', 'drug', 'time',
                              'albumin'))
PBC <- na.omit(PBC) 

# Specify simple univariate fit
long.formulas <- list(
  albumin ~ time + (1 + time|id)
)
surv.formula <- Surv(survtime, status) ~ drug

fit <- joint(long.formulas, surv.formula, PBC, family = list('gaussian'))

fixef(fit, 'long')
fixef(fit, 'surv')
}
\seealso{
\code{\link{ranef.joint}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
