% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specresponse.R
\name{specresponse}
\alias{specresponse}
\title{Species response curves}
\usage{
specresponse(species, var, main, xlab, method = "env", axis = 1, df = 5,
  ylog = FALSE)
}
\arguments{
\item{species}{Vector containing species abundances (per plot).}

\item{var}{Vector containing environmental variable (per plot) \strong{OR} \code{vegan} ordination result object if \code{method = "ord"}.}

\item{main}{Optional: Main title.}

\item{xlab}{Optional: Label of x-axis.}

\item{method}{Method defining the type of variable. Default \code{method = "env"} fits a response curve to environmental variables. Alternatively \code{method = "ord"} fits a response along an ordination axis.}

\item{axis}{Ordination axis (only if \code{method = "ord"}).}

\item{df}{Desired equivalent number of degrees of freedom (trace of the smoother matrix). Default = 5.}

\item{ylog}{If set on \code{TRUE} the y-axis is displayed on a log-scale. Default is to not log y-axis.}
}
\description{
This function draws species response curves for rough interpretation of a species response to environmental gradients or ordination axes.
It is based on \code{\link[stats]{smooth.spline}} which fits a cubic smoothing spline to the supplied data.
For drawing multiple curves into one plot use \code{\link{specresponses}}.
}
\section{Details}{

For response curves based on environmental variable gradients the argument \code{var} takes a single vector containing the variable corresponding to the species abundances. The direct response of a species to the environmental variable is shown.

For a response to ordination axis (\code{method = "ord"}) the argument \code{var} requires a \code{vegan} ordination result object (e.g. from \code{\link[vegan]{decorana}}, \code{\link[vegan]{cca}}, \code{\link[vegan]{rda}} or \code{\link[vegan]{metaMDS}}).
Response of species to axis is shown; note that meaning of axis differ in unconstrained and constrained methods.
First axis is used as default.

A minimum of 10 occurences is recommenced to use response curves. Curves for species with less than 5 occurences are not drawn.
It is recommended to filter the vegetation matrix for species with a minimum frequency of 10 before using this function.
}
\examples{
## Draw species response curve on environmental variable
specresponse(schedenveg$ArrElat, schedenenv$soil_depth)

## Draw species response curve on environmental variable with
## custom labels, lower df and log-scaled y-axis
specresponse(schedenveg$ArrElat, schedenenv$soil_depth, main = "Arrhenatherum elatius",
       xlab = "Soil depth", df = 3, ylog = TRUE)

## Draw species response curve on ordination axes
## First calculate DCA
library(vegan)
scheden.dca <- decorana(schedenveg)

specresponse(schedenveg$ArrElat, scheden.dca, method = "ord")
specresponse(schedenveg$ArrElat, scheden.dca, method = "ord", axis = 2)
}
\author{
Friedemann Goral (\email{fgoral@gwdg.de}) and Jenny Schellenberg
}
\seealso{
\code{\link{specresponses}}
}

