% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customization.R
\name{make_check}
\alias{make_check}
\title{Create a check function}
\usage{
make_check(description, check, gp, ...)
}
\arguments{
\item{description}{A description of the check.}

\item{check}{A function that takes the \code{state} as an argument.}

\item{gp}{A short description of what is good practice.}

\item{...}{Further arguments.}
}
\description{
Create a check function
}
\examples{
# make a preparation function
url_prep <- make_prep(
  name = "desc", 
  func = function(path, quiet) desc::description$new(path)
)
# and the corresponding check function
url_chk <- make_check(
  description = "URL field in DESCRIPTION",
  tags = character(),
  preps = "desc",
  gp = "have a URL field in DESCRIPTION",
  check = function(state) state$desc$has_fields("URL")
)
# use together in gp()
bad1 <- system.file("bad1", package = "goodpractice")
res <- gp(bad1, checks = "no_description_depends",
          extra_preps = list("desc" = url_prep),
          extra_checks = list("url" = url_chk))
}
