% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{ga_accounts}
\alias{ga_accounts}
\title{List account metadata}
\usage{
ga_accounts()
}
\value{
A \code{data.frame} with accountid, name, an R datetime object (\code{POSIXct}) when the account was created and last updated, and the effective permissions your user has for those accounts.
}
\description{
This gets a list of account meta data, that can be used in other management API functions.
}
\details{
This gets the meta data associated with the accounts you have access to with your user.  
If you want all information such as web properties and viewIds, use \link{ga_account_list} instead.
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()
ga_accounts()

}
}
\seealso{
Other account structure functions: \code{\link{ga_account_list}},
  \code{\link{ga_view_list}}, \code{\link{ga_view}},
  \code{\link{ga_webproperty_list}},
  \code{\link{ga_webproperty}}
}
\concept{account structure functions}
