\name{googleVis-package}
\alias{googleVis-package}
\alias{googleVis}
\docType{package}
\title{
Using the Google Visualisation API with R
}
\description{
  The googleVis package provides an interface between R and the Google
  Visualisation API. Users of the googleVis package can easily create web
  pages with interactive charts based on R data frames and display them
  either with the local R HTTP help server or within their own sites,
  without uploading the data to Google.
  
  A browser with Flash and Internet connection is required. Please visit
  the project web site for more information and examples:
  \url{http://code.google.com/p/google-motion-charts-with-r/}.
} 
\details{
\tabular{ll}{
	Package: \tab googleVis\cr
	Type: \tab Package\cr
	Version: \tab 0.2.15\cr
	Date: \tab 2012-03-04\cr
	License: \tab GPL version 2 or later\cr
	 }
	}
\author{
	Markus Gesmann, Diego de Castillo
	}
\note{
  See \code{vignette("googleVis")} for an introduction to the
  \code{googleVis} package. 
  
  Of course there are many alternative visualisation toolkits out
  there, e.g. 
  \itemize{
    \item Many Eyes:
    \url{http://services.alphaworks.ibm.com/manyeyes/page/Create_a_Visualization.html}    
    \item Open Flash Chart (Flash):
    \url{http://teethgrinder.co.uk/open-flash-chart/} 
    \item OpenLayers (JavaScript): \url{http://www.openlayers.org/} 
    \item Processing (Java): \url{http://processing.org/}
    \item simile (AJAX): \url{http://simile.mit.edu/}
    \item FLARE (ActionScript): \url{http://flare.prefuse.org/}
  }

  See the Google Public Data Explorer for examples using the Google
  Visualisation API: \url{http://www.google.com/publicdata/home}
  
  Other R packages of interest to you might be:
  \itemize{
    \item plotGoogleMaps: Plot HTML output with Google Maps API and your own data. \url{http://cran.r-project.org/web/packages/plotGoogleMaps/}
    \item R2GoogleMaps: Provides a mechanism to generate JavaScript code from R that displays data using Google Maps. \url{http://www.omegahat.org/R2GoogleMaps/}
    \item RgoogleMaps: Overlays on Google map tiles in R. \url{http://cran.r-project.org/web/packages/RgoogleMaps/index.html}
    \item animation: A Gallery of Animations in Statistics and Utilities to Create Animations. \url{http://cran.r-project.org/web/packages/animation/}
    \item gridSVG: Export grid graphics as SVG/ \url{http://cran.r-project.org/web/packages/gridSVG/}
    \item SVGAnnotation: Tools for Post-Processing SVG Plots Created in R \url{http://www.omegahat.org/SVGAnnotation/}
    \item RSVGTipsDevice: An R SVG graphics device with dynamic tips and hyperlinks. \url{http://cran.r-project.org/web/packages/RSVGTipsDevice/}
    \item iWebPlots: Interactive web-based plots. \url{http://cran.r-project.org/web/packages/iWebPlots/}
  }   
}
\references{
  \itemize{
	\item googleVis project site: \url{http://code.google.com/p/google-motion-charts-with-r/}
	\item Google Visualisation API: \url{http://code.google.com/apis/visualization/interactive_charts.html}
	\item Google Terms of Use: \url{http://code.google.com/apis/chart/interactive/terms.html}
	\item Google Maps API Terms of Service: \url{http://code.google.com/apis/maps/terms.html}
      }
}
\examples{
\dontrun{
  demo(googleVis)
  ## For other demos see
  demo(package='googleVis')	
  }
}
\keyword{ package }


