% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gvisPieGaugeChart.R
\name{gvisGauge}
\alias{gvisGauge}
\title{Google Gauge with R
\Sexpr{googleChartName <- "gauge"}
\Sexpr{gvisChartName <- "gvisGauge"}}
\usage{
gvisGauge(data, labelvar = "", numvar = "", options = list(), chartid)
}
\arguments{
\item{data}{a \code{\link{data.frame}} to be displayed as a gauge}

\item{labelvar}{name of the character column which contains the category
labels for the slice labels.}

\item{numvar}{a vector of column names of the numerical variables of the
slice values.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME",
googleChartName,
readLines(file.path(".", "inst",  "mansections",
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst",
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst",
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisGauge function reads a data.frame and creates text output referring
to the Google Visualisation API, which can be included into a web page, or
as a stand-alone page. The actual chart is rendered by the web browser using
SVG or VML.
}
\examples{
## Please note that by default the googleVis plot command
## will open a browser window and requires an internet
## connection to display the visualisation.

Gauge1 <- gvisGauge(CityPopularity, options=list(min=0, max=800, greenFrom=500,
                    greenTo=800, yellowFrom=300, yellowTo=500,
                    redFrom=0, redTo=300))

plot(Gauge1)
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\references{
Google Chart Tools API:
\Sexpr[results=rd]{gsub("CHARTNAME",
googleChartName,
readLines(file.path(".", "inst",  "mansections",
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for
printing and plotting methods
}
\keyword{iplot}

