% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_read_csv.R
\name{gs_read_csv}
\alias{gs_read_csv}
\title{Read data via the \code{exportcsv} link}
\usage{
gs_read_csv(ss, ws = 1, ..., verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{...}{\strong{Optional} arguments to control data download, parsing, and
  reshaping; for most purposes, the defaults should be fine. Anything that is
  not listed here will be silently ignored.
\describe{
  \item{\code{progress}}{Logical. Whether to display download progress if in
  an interactive session.}
  \item{\code{col_types}}{Seize control of type conversion for variables.
  Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}. Follow those links
  or read the \code{vignette("column-types")} for details.}
  \item{\code{locale, trim_ws, na}}{Specify locale, the fate of leading or
  trailing whitespace, or a character vector of strings that should become
  missing values. Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}.}
  \item{\code{comment, skip, n_max}}{Specify a string used to identify
  comments, request to skip lines before reading data, or specify the
  maximum number of data rows to read.}
  \item{\code{col_names}}{Either \code{TRUE}, \code{FALSE} or a character
  vector of column names. If \code{TRUE}, the first row of the data rectangle
  will be used for names. If \code{FALSE}, column names will be X1, X2, etc.
  If a character vector, it will be used as column names. If the sheet
  contains column names and you just don't like them, specify \code{skip = 1}
  so they don't show up in your data.}
  \item{\code{check.names}}{Logical. Whether to run column names through
  \code{\link{make.names}} with \code{unique = TRUE}, just like
  \code{\link{read.table}} does. By default, \code{googlesheets} implements
  the \code{readr} data ingest philosophy, which leaves column names "as is",
  with one exception: data frames returned by \code{googlesheets} will have
  a name for each variable, even if we have to create one.}
}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{data.frame} or, if \code{dplyr} is loaded, a
  \code{\link[dplyr]{tbl_df}}
}
\description{
This function reads all data from a worksheet and returns it as a
\code{tbl_df} or \code{data.frame}. Don't be spooked by the "csv" thing --
the data is NOT actually written to file during this process. Data is read
from the "maximal data rectangle", i.e. the rectangle spanned by the maximal
row and column extent of the data. By default, empty cells within this
rectangle will be assigned \code{NA}. This is the fastest method of data
consumption, so use it as long as you can tolerate the lack of control re:
which cells are being read.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
oceania_csv <- gs_read_csv(gap_ss, ws = "Oceania")
str(oceania_csv)
oceania_csv

## crazy demo of passing args through to readr::read_csv()
oceania_crazy <- gs_read_csv(gap_ss, ws = "Oceania",
  col_names = paste0("Z", 1:6), na = "1962", col_types = "cccccc", skip = 1)
oceania_crazy
}
}
\seealso{
Other data consumption functions: \code{\link{gs_read_cellfeed}},
  \code{\link{gs_read_listfeed}}, \code{\link{gs_read}},
  \code{\link{gs_reshape_cellfeed}},
  \code{\link{gs_simplify_cellfeed}}
}
\concept{data consumption functions}
