% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{gauge_tour}
\alias{gauge_tour}
\title{Gauging a tour}
\usage{
gauge_tour(To, n)
}
\arguments{
\item{To}{Tour to be gauged, a vector containing a permutation of
the 1:n sequence}

\item{n}{Number of elements of the tour T}
}
\value{
The gauged tour.
}
\description{
Gauging a tour for easy comparison.
}
\details{
A tour of \eqn{n} vertices is a permutation of the ordered
sequence 1:\eqn{n}, and it is represented as a vector
containing the integers from 1 to \eqn{n} in the permuted
sequence.  As a subgraph of the complete graph with \eqn{n}
vertices, it is assumed that each vertex is adjacent with the
anterior and posterior ones, with the first and last being
also adjacent.

With respect to the TSP, a tour is invariant under cyclic
permutation and inversion, so that there exists \eqn{(n-1)!/2}
different tours in a complete graph of \eqn{n} vertices.  When
searching for tours it is common to find the same tour under a
different representation.  Therefore, we need to establish
wheter two tours are equivalent or not.  To this end, we can
"gauge" the tour by permuting cyclically its elements until
the first vertex is at position 1, and fix the orientation so
that the second vertex is less than the last.  Two equivalent
tours will have the same "gauged" representation.

This function is used in \link{search_tour_genetic} to discard repeated
tours which can be found during the execution of the
algorithm.
}
\examples{
set.seed(2)
T0 <- sample(1:9,9)   #        T0 = 2 6 5 9 7 4 1 8 3
gauge_tour(T0, 9)     # gauged T0 = 1 4 7 9 5 6 2 3 8

}
\seealso{
\link{search_tour_genetic} implements a version of the genetic
algorithm for the TSP.
}
\author{
Cesar Asensio
}
