% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendallW.R
\name{kendallW}
\alias{kendallW}
\alias{kendallW.default}
\alias{kendallW.pltree}
\title{Kendall's W (coefficient of concordance)}
\usage{
kendallW(x, ...)

\method{kendallW}{default}(x, y, ...)

\method{kendallW}{pltree}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{pltree}}

\item{...}{additional arguments passed to methods}

\item{y}{an object of class \code{pltree}}

\item{newdata}{data for predictions}
}
\value{
Kendall's W (coefficient of concordance)
}
\description{
Compute Kendall's W, also known as coefficient of concordance among observed rankings
and those predicted by the Plackett-Luce model.
}
\details{
It is as wrapper of the function DescTools::KendallW, adapted to compute the Kendall's W
on the observed and predicted rankings.
 
Kendall's W values range between 0 (no agreement) to 1 (full agreement)
}
\seealso{
Other goodness-of-fit functions: 
\code{\link{kendallTau}()},
\code{\link{pseudoR2}()}
}
\author{
David Brown and Jacob van Etten
}
\concept{goodness-of-fit functions}
