% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{set_prediction_data}
\alias{set_prediction_data}
\title{Generic 'set_prediction_data' method for a \code{GPModel}}
\usage{
set_prediction_data(gp_model, group_data_pred = NULL,
  group_rand_coef_data_pred = NULL, gp_coords_pred = NULL,
  gp_rand_coef_data_pred = NULL, cluster_ids_pred = NULL, X_pred = NULL)
}
\arguments{
\item{gp_model}{A \code{GPModel}}

\item{group_data_pred}{A \code{vector} or \code{matrix} with elements being group levels 
for which predictions are made (if there are grouped random effects in the \code{GPModel})}

\item{group_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data 
for grouped random coefficients (if there are some in the \code{GPModel})}

\item{gp_coords_pred}{A \code{matrix} with prediction coordinates (=features) for 
Gaussian process (if there is a GP in the \code{GPModel})}

\item{gp_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data for 
Gaussian process random coefficients (if there are some in the \code{GPModel})}

\item{cluster_ids_pred}{A \code{vector} with elements indicating the realizations of 
random effects / Gaussian processes for which predictions are made 
(set to NULL if you have not specified this when creating the \code{GPModel})}

\item{X_pred}{A \code{matrix} with prediction covariate data for the 
fixed effects linear regression term (if there is one in the \code{GPModel})}
}
\description{
Generic 'set_prediction_data' method for a \code{GPModel}
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
set.seed(1)
train_ind <- sample.int(length(y),size=250)
gp_model <- GPModel(group_data = group_data[train_ind,1], likelihood="gaussian")
set_prediction_data(gp_model, group_data_pred = group_data[-train_ind,1])
}

}
\author{
Fabio Sigrist
}
