% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{parEsts}
\alias{parEsts}
\title{Essential Parameter Estimation Results}
\usage{
parEsts(object, level = 0.95)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{level}{scalar from 0 to 1. The confidence level required.}
}
\value{
A data.frame containing the estimated parameters, standard errors, and the lower and upper bounds of the confidence intervals.
}
\description{
Extracts the essential parameter estimation results for a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
lgcmFit <- fit(lgcm)
paramEssentials <- parEsts(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
