% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zdna.R
\name{zdna}
\alias{zdna}
\title{Predicting Z-DNA motif(s)}
\usage{
zdna(x, xformat = "default")
}
\arguments{
\item{x}{DNA sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which Z-DNA motif(s) will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank (GenBank accession number(s)).}
}
\value{
A dataframe of Z-DNA motif(s) position, sequence, length and likeliness. If more than one DNA sequence is provided as argument, an input ID is returned for motif(s) predicted from each input sequence.
}
\description{
This function predicts Z-DNA motif(s)
in 'x' in DNA. DNA sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts Z-DNA motif(s) in DNA sequences and provide the position, sequence and length of the predicted motif(s). If any motif is predicted, the degree of likeliness for the motif to be formed is computed and scored as ** (more likely) or as * (less likely).
}
\examples{
 ## Predicting Z-DNA motif(s) from raw DNA sequences
E1 <- c("TCTTGCGCGCGCGCGCGCGCGCGCGCAAT", "taggtgctgggaggtagagacaggatatcct")
zdna(E1)

## Predicting Z-DNA motif(s) from DNA sequences in fasta file
## Not run: zdna(x="Example.fasta", xformat = "fasta")

## Predicting Z-DNA motif(s) from DNA sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: zdna(c("BH114913", "AY611035"), xformat = "GenBank")
}
\references{
paper under review
}
\author{
Hannah O. Ajoge
}
