% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_plot_compar.R
\name{graph_plot_compar}
\alias{graph_plot_compar}
\title{Visualize the topological differences between two spatial graphs on a map}
\usage{
graph_plot_compar(x, y, crds)
}
\arguments{
\item{x}{A graph object of class \code{igraph}.
Its nodes must have the same names as in graph \code{y}.}

\item{y}{A graph object of class \code{igraph}.
Its nodes must have the same names as in graph \code{x}.}

\item{crds}{A \code{data.frame} with the spatial
coordinates of the graph nodes (both \code{x} and \code{y}).
It must have three columns:
\itemize{
\item{ID: Name of the graph nodes (character string).
The names must be the same as the node names of the graphs of
class \code{igraph} (\code{igraph::V(graph)$name})}
\item{x: Longitude of the graph nodes (numeric or integer).}
\item{y: Latitude of the graph nodes (numeric or integer).}
}}
}
\value{
A ggplot2 object to plot
}
\description{
The function enables to compare two spatial graphs by
plotting them highlighting the topological similarities and differences
between them. Both graphs should share the same nodes and cannot
be directed graphs.
}
\details{
The graphs \code{x} and \code{y} of class \code{igraph} must have
node names (not necessarily in the same order as IDs in crds,
given a merging is done).
}
\examples{
data(pts_pop_simul)
data(data_simul_genind)
mat_w <- mat_gen_dist(data_simul_genind, dist = "DPS")
mat_dist <- mat_geo_dist(data = pts_pop_simul,
                         ID = "ID",
                         x = "x",
                         y = "y")
mat_dist <- mat_dist[order(as.character(row.names(mat_dist))),
                   order(as.character(colnames(mat_dist)))]
g1 <- gen_graph_topo(mat_w = mat_w, topo = "mst")
g2 <- gen_graph_topo(mat_w = mat_w, mat_topo = mat_dist, topo = "gabriel")
g <- graph_plot_compar(x = g1, y = g2,
                       crds = pts_pop_simul)
}
\author{
P. Savary
}
