% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graphab.R
\name{get_graphab}
\alias{get_graphab}
\title{Download Graphab if not present on the user's machine}
\usage{
get_graphab(res = TRUE, return = FALSE)
}
\arguments{
\item{res}{Logical indicating whether a message says if Graphab has been
downloaded or not.}

\item{return}{Logical indicating whether the function returns a 1 or a 0
to indicate if Graphab has been downloaded or not.}
}
\value{
If res = TRUE, the function displays a message indicating to users
what has been done.
If return = TRUE, it returns a 0 if Graphab is already on the machine and
a 1 if it has been downloaded.
}
\description{
The function checks for the presence of Graphab (.jar) on the
user's machine and downloads it if absent. It also checks that users have
installed java on their machine.
}
\details{
If the download does not work, you can create a directory named
'graph4lg_jar' in the directory \code{rappdirs::user_data_dir()} and copy
Graphab software downloaded from
\url{https://thema.univ-fcomte.fr/productions/download.php?name=graphab&version=2.8&username=Graph4lg&institution=R}
}
\examples{
\dontrun{
get_graphab()
}
}
\author{
P. Savary
}
