% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_helpers.R
\name{simu_px_HR}
\alias{simu_px_HR}
\title{Simulate HR extremal functions}
\usage{
simu_px_HR(n, d, idx, trend, chol_mat)
}
\arguments{
\item{n}{Number of simulations.}

\item{d}{Dimension of the multivariate Pareto
distribution.}

\item{idx}{Integer. Index corresponding to the variable over which
the extremal function is simulated.}

\item{trend}{Numeric. Trend corresponding to the variable \code{idx}.}

\item{chol_mat}{Numeric matrix \eqn{d\times d}{d x d}.
Cholesky decomposition of the desired covariance matrix.}
}
\value{
Numeric matrix \eqn{n\times d}{n x d}. Simulated data.
}
\description{
Simulates the Huessler--Reiss extremal functions
}
