% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.LG.R
\name{est.LG}
\alias{est.LG}
\title{Estimate graphons based on empirical degrees}
\usage{
est.LG(A, K = 2)
}
\arguments{
\item{A}{an \eqn{(n\times n)} binary adjacency matrix.}

\item{K}{the number of blocks provided by an user.}
}
\value{
a named list containing
\describe{
\item{H}{a  \eqn{(K\times K)} matrix of 3D histogram.}
\item{P}{an \eqn{(n\times n)} corresponding probability matrix.}
\item{B}{a length-\eqn{K} list where each element is a vector of nodes/indices
for each cluster.}
}
}
\description{
\code{est.LG} takes a 2-stage approach. First it adopts largest gap criterion on empirical degrees to
estimate blocks of a given network under Stochastic Blockmodel framework.
Then a consistent histogram estimator is utilized to estimate graphons based on
estimated blocks in a given network.
}
\examples{
## generate a graphon of type No.5 with 3 clusters
W = gmodel.preset(3,id=10)

## create a probability matrix for 20 nodes
graphW = gmodel.block(W,n=20)
P = graphW$P

## draw 23 observations from a given probability matrix
A = gmodel.P(P,rep=23,symmetric.out=TRUE)

## run LG algorithm with a rough guess for K=2,3,4
res2 = est.LG(A,K=2)
res3 = est.LG(A,K=3)
res4 = est.LG(A,K=4)

## compare true probability matrix and estimated ones
opar = par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(P, main="original P matrix")
image(res2$P, main="LG with K=2")
image(res3$P, main="LG with K=3")
image(res4$P, main="LG with K=4")
par(opar)

}
\references{
\insertRef{Channarond2011}{graphon}

\insertRef{chan2014}{graphon}
}
\seealso{
\code{\link{est.SBA}}
}
