## ---- message=F, warning=F----------------------------------------------------
library('mvtnorm')
library("igraph")
library("gplots")
library("graphsim")
Rprof("test_graph_network_inhibiting.out", interval = 0.001, memory.profiling = F)
#Rprof("test_graph_network_inhibiting.mem.out", interval = 0.001, memory.profiling = T)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
graph_test4_edges <- rbind(c("A", "C"), c("B", "C"), c("C", "D"), c("D", "E"), c("D", "F"), c("F", "G"), c("F", "I"), c("H", "I"))
graph_test4 <- graph.edgelist(graph_test4_edges, directed = T)
state_vec <- c(1, 1, 1, 1, -1, 1, 1, 1)
plot_directed(graph_test4, layout = layout.kamada.kawai, state = state_vec)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
adj_mat <- make_adjmatrix_graph(graph_test4)
heatmap.2(make_adjmatrix_graph(graph_test4), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_adjmatrix_graph(graph_test4, directed = T), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
comm_mat <- make_commonlink_graph(graph_test4)
heatmap.2(make_commonlink_graph(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
shortest.paths(graph_test4)
heatmap.2(shortest.paths(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
(diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4)
heatmap.2((diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
make_distance_graph(graph_test4, absolute = F)
make_distance_graph(graph_test4, absolute = T)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#sigma from adj mat
make_sigma_mat_graph(graph_test4, 0.8)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#sigma from comm mat
make_sigma_mat_graph(graph_test4, 0.8, comm = T)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8, comm = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# sigma from distance matrix
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T)
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F)
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#simulate expression data
#adj mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =F, state = state_vec) # unable to generate from adj mat ## fixed with positive definite correction
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#comm mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =T, state = state_vec) #expression from comm mat
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#absolute dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = T, state = state_vec) # unable to generate from adj mat ## fixed PD
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# relative dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = F, state = state_vec)
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
graph_test4_edges <- rbind(c("A", "C"), c("B", "C"), c("C", "D"), c("D", "E"), c("D", "F"), c("F", "G"), c("F", "I"), c("H", "I"))
graph_test4 <- graph.edgelist(graph_test4_edges, directed = T)
state_vec <- c(1, 1, 1, -1, -1, -1, 1, 1)
plot_directed(graph_test4, layout = layout.kamada.kawai, state = state_vec)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
adj_mat <- make_adjmatrix_graph(graph_test4)
heatmap.2(make_adjmatrix_graph(graph_test4), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_adjmatrix_graph(graph_test4, directed = T), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
comm_mat <- make_commonlink_graph(graph_test4)
heatmap.2(make_commonlink_graph(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
shortest.paths(graph_test4)
heatmap.2(shortest.paths(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
(diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4)
heatmap.2((diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
make_distance_graph(graph_test4, absolute = F)
make_distance_graph(graph_test4, absolute = T)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#sigma from adj mat
make_sigma_mat_graph(graph_test4, 0.8)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#sigma from comm mat
make_sigma_mat_graph(graph_test4, 0.8, comm = T)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8, comm = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# sigma from distance matrix
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T)
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F)
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#simulate expression data
#adj mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =F, state = state_vec) # unable to generate from adj mat ## fixed with positive definite correction
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#comm mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =T, state = state_vec) #expression from comm mat
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#absolute dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = T, state = state_vec) # unable to generate from adj mat ## fixed PD
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# relative dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = F, state = state_vec)
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
graph_test4_edges <- rbind(c("A", "C"), c("B", "C"), c("C", "D"), c("D", "E"), c("D", "F"), c("F", "G"), c("F", "I"), c("H", "I"))
graph_test4 <- graph.edgelist(graph_test4_edges, directed = T)
state_vec <- "inhibiting"
plot_directed(graph_test4, layout = layout.kamada.kawai, state = state_vec)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
adj_mat <- make_adjmatrix_graph(graph_test4)
heatmap.2(make_adjmatrix_graph(graph_test4), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_adjmatrix_graph(graph_test4, directed = T), scale = "none", trace = "none", col = colorpanel(3, "grey75", "white", "blue"), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
comm_mat <- make_commonlink_graph(graph_test4)
heatmap.2(make_commonlink_graph(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
shortest.paths(graph_test4)
heatmap.2(shortest.paths(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
(diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4)
heatmap.2((diameter(graph_test4)-shortest.paths(graph_test4))/diameter(graph_test4), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
make_distance_graph(graph_test4, absolute = F)
make_distance_graph(graph_test4, absolute = T)

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#sigma from adj mat
make_sigma_mat_graph(graph_test4, 0.8)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#sigma from comm mat
make_sigma_mat_graph(graph_test4, 0.8, comm = T)
heatmap.2(make_sigma_mat_graph(graph_test4, 0.8, comm = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# sigma from distance matrix
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T)
make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F)
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = T), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(make_sigma_mat_dist_graph(graph_test4, 0.8, absolute = F), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

## ---- out.width = '50%', out.height  = '50%', fig.align='center', dpi=36------
#simulate expression data
#adj mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =F, state = state_vec) # unable to generate from adj mat ## fixed with positive definite correction
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#comm mat
expr <- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm =T, state = state_vec) #expression from comm mat
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
#absolute dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = T, state = state_vec) # unable to generate from adj mat ## fixed PD
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
# relative dist
expr<- generate_expression(100, graph_test4, cor = 0.8, mean = 0, comm = F, dist = T, absolute = F, state = state_vec)
heatmap.2(expr, scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))
heatmap.2(cor(t(expr)), scale = "none", trace = "none", col = bluered(50), colsep = 1:length(V(graph_test4)), rowsep = 1:length(V(graph_test4)))

