% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflator.R
\name{inflator}
\alias{inflator}
\title{Inflate using a general index}
\usage{
inflator(x = 1, from, to, inflator_table, index.col = "Index",
  time.col = "Time", roll = NULL)
}
\arguments{
\item{x}{The vector to be inflated.}

\item{from}{The contemporaneous time of x.}

\item{to}{The target time (in units of the \code{inflator_table}) to which x is to be inflated.}

\item{inflator_table}{A \code{data.table} having columns \code{index.col} and \code{time.col}.}

\item{index.col}{The column in \code{inflator_table} containing the index used for inflation.}

\item{time.col}{The column in \code{inflator_table} by which times are mapped.}

\item{roll}{If \code{NULL}, inflation is calculated only on exact matches in \code{inflator_table}. Otherwise, uses a rolling join. See \code{data.table::data.table}.}
}
\value{
A vector of inflated values. For example, \code{inflator_table = grattan:::cpi_seasonal_adjustment}, 
\code{index.col = "obsValue"}, \code{time.col = "obsTime"}, gives the CPI inflator.
}
\description{
Inflate using a general index
}

