% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fy.year.R
\name{is.fy}
\alias{date2fy}
\alias{fy.year}
\alias{fy2date}
\alias{fy2yr}
\alias{is.fy}
\alias{yr2fy}
\title{Convenience functions for dealing with financial years}
\arguments{
\item{yr_ending}{An integer representing a year.}

\item{fy.yr}{A string suspected to be a financial year.}

\item{date}{A string or date for which the financial year is desired. Note that \code{yr2fy} does not check its argument is an integer.}
}
\value{
For \code{is.fy}, a logical, whether its argument is a financial year.
The following forms are allowed: \code{2012-13}, \code{201213}, \code{2012 13}, only.
For \code{fy.year}, \code{yr2fy}, and \code{date2fy}, the financial year. 
For the inverses, a numeric corresponding to the year.
}
\description{
Convenience functions for dealing with financial years
}
\examples{
is.fy("2012-13")
is.fy("2012-14")
yr2fy(2012)
fy2yr("2015-16")
date2fy("2014-08-09")
}

