% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_pension_age.R
\name{age_pension_age}
\alias{age_pension_age}
\title{Age of eligibility for the Age Pension}
\source{
\url{https://guides.dss.gov.au/guide-social-security-law/3/4/1/10}
}
\usage{
age_pension_age(when = Sys.Date(), sex = "male")
}
\arguments{
\item{when}{Either a Date (or a character vector coercible to such) or a financial year,
when the age of eligibility of Age Pension is requested. Defaults to current date.}

\item{sex}{A character vector the same length as \code{when}, containing strings \code{"male"} and \code{"female
"}. May be abbreviated to \code{"m"} or \code{"f"} and is case-insensitive.}
}
\value{
A numeric vector, the age of eligiblity for the Age Pension for each \code{when}.
}
\description{
Age of eligibility for the Age Pension
}
\examples{
age_pension_age()  # Current age of eligiblity
age_pension_age("1995-12-31")
age_pension_age("2013-14")
}
