% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gni_qtr.R
\name{gni}
\alias{gni}
\alias{gni_qtr}
\alias{gni_fy}
\title{Gross National Income, Australia}
\source{
Australian Bureau of Statistics, Catalogue 5206.0. Series A2304354T.
}
\usage{
gni_qtr(date, roll = "nearest")

gni_fy(fy_year)
}
\arguments{
\item{date}{A Date vector or character coercible thereto.}

\item{roll}{Passed to \code{data.table} when joining.}

\item{fy_year}{Character vector of financial years.}
}
\value{
For \code{gni_qtr}, the quarterly GNI for the nearest quarter date. 
For \code{gni_fy} the sum over the quarters in the financial year provided. 
If \code{fy_year} would provide incomplete data (i.e. only sum three or fewer quarters), a warning is issued.
Dates or fy_year outside the available data is neither a warning nor an error, but \code{NA}.
}
\description{
Gross national income, at contemporaneous prices (called 'current prices' by the ABS).
}
