% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_taildepCoeff.R
\name{taildepCoeff}
\alias{taildepCoeff}
\alias{TDC}
\alias{taildepCoeff.Network}
\alias{taildepCoeff.HRMtree}
\title{Tail dependence coefficients}
\usage{
taildepCoeff(obj, ...)

\method{taildepCoeff}{Network}(obj, k_ratio, v, correction = FALSE, ...)

\method{taildepCoeff}{HRMtree}(obj, v, ...)
}
\arguments{
\item{obj}{should be of class \code{Network} or \code{HRMtree} or a subclass of these, such as
\code{Tree, BlochGraph} as subclasses of \code{Network} or subclasses \code{MME, MLE, MLE1, MLE2, EKS, EKS_part,
EngHitz, MLEave, MMEave} of class \code{HRMtree}.}

\item{...}{additional arguments}

\item{k_ratio}{the number of upper order statistics divided by the total number of observations}

\item{v}{a named vector of coordinates, the names should correspond to the names of the nodes
in the graph in \code{obj}}

\item{correction}{adds a correction of one half to n-k in computing the event {x > n - k + 1/2}.
Default is FALSE, hence n-k.}
}
\value{
A scalar representing the value of the tdc. If the \code{obj} is of class \code{Network} the TDC are non-parametric. If the \code{obj} is of class
\code{HRMtree} or its subclasses respectively the TDC are parametric.
}
\description{
It computes parametric (Huesler-Reiss) or non-parametric Tail dependence coefficients -
See www.gremes.info "Application - Danube" for usage of TDCs.
}
\examples{
# non-parametric tdc
g<- graph(c(1,2,2,3), directed=FALSE)
g<- set.vertex.attribute(g, "name", V(g), c("a", "b", "c")) # name the nodes
data<- matrix(rnorm(1000*3), 1000,3)
colnames(data)<- c("a", "b", "c")  # name the columns
net<- Network(x = g, data = data)
v<- c(1,0,1)
names(v)<- c("a", "b", "c")
taildepCoeff(net, 0.2, v = v, correction = TRUE)
# parametric tdc
g<- graph(c(1,2,2,3), directed=FALSE)
g<- set.vertex.attribute(g, "name", V(g), c("a", "b", "c")) # name the nodes
obj<- HRMtree(g)
obj<- setParams(obj, c(0.5,0.6))
taildepCoeff(obj, v)
}
