% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{accuracy.greybox}
\alias{accuracy.greybox}
\alias{accuracy.predict.greybox}
\title{Error measures for an estimated model}
\usage{
\method{accuracy}{greybox}(object, holdout = NULL, ...)

\method{accuracy}{predict.greybox}(object, holdout = NULL, ...)
}
\arguments{
\item{object}{The estimated model or a forecast from the estimated model generated via
either \code{predict()} or \code{forecast()} functions.}

\item{holdout}{The vector of values of the response variable in the holdout (test) set.
If not provided, then the function will return the in-sample error measures.}

\item{...}{Other variables passed to the \code{forecast()} function (e.g. \code{newdata}).}
}
\description{
Function produces error measures for the provided object and the holdout values of the
response variable. Note that instead of parameters \code{x}, \code{test}, the function
accepts the vector of values in \code{holdout}. Also, the parameters \code{d} and \code{D}
are not supported - MASE is always calculated via division by first differences.
}
\details{
The function is a wrapper for the \link[greybox]{measures} function and is implemented
for convenience.
}
\examples{

xreg <- cbind(rlaplace(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rlaplace(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

ourModel <- alm(y~x1+x2+trend, xreg, subset=c(1:80), distribution="dlaplace")
predict(ourModel,xreg[-c(1:80),]) |>
   accuracy(xreg[-c(1:80),"y"])
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
