% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_ppplist.R
\name{op_ppplist}
\alias{op_ppplist}
\alias{fv_ppplist}
\alias{dist_ppplist}
\title{Batch Operations of \code{'ppplist'} Object}
\usage{
fv_ppplist(x, ...)

dist_ppplist(x, ...)

op_ppplist(
  x,
  op,
  mc.cores = switch(.Platform$OS.type, windows = 1L, detectCores()),
  ...
)
}
\arguments{
\item{x}{a \code{'ppplist'} object}

\item{...}{additional parameters of workhorse functions
\code{\link[=fv_ppp]{fv_ppp()}} or \code{\link[=dist_ppp]{dist_ppp()}}}

\item{op}{workhorse \link[base]{function}, either \code{\link[=fv_ppp]{fv_ppp()}} or \code{\link[=dist_ppp]{dist_ppp()}}}

\item{mc.cores}{\link[base]{integer} scalar, see function \link[parallel]{mclapply}.
Default is 1L on Windows, or \link[parallel]{detectCores} on Mac.
CRAN requires \code{mc.cores <= 2L} in examples.}
}
\value{
Function \code{\link[=fv_ppplist]{fv_ppplist()}} returns a \link[base]{list} of function \code{\link[=fv_ppp]{fv_ppp()}} returns.

Function \code{\link[=dist_ppplist]{dist_ppplist()}} returns a \link[base]{list} of function \code{\link[=dist_ppp]{dist_ppp()}} returns.
}
\description{
Batch operations of function \code{\link[=fv_ppp]{fv_ppp()}} or \code{\link[=dist_ppp]{dist_ppp()}}, for a \code{'ppplist'} input.
}
\details{
Function \code{\link[=fv_ppplist]{fv_ppplist()}} is a \pkg{parallel} batch process of the workhorse function \code{\link[=fv_ppp]{fv_ppp()}}.

Function \code{\link[=dist_ppplist]{dist_ppplist()}} is a \pkg{parallel} batch process of the workhorse function \code{\link[=dist_ppp]{dist_ppp()}}.
}
\examples{
library(spatstat.data)
library(spatstat.geom) # for ?spatstat.geom::split.ppp
library(spatstat.explore) # for ?spatstat.explore::Emark, etc.

Vc = with(shapley$marks, expr = {
 cut.default(V, breaks = quantile(V, probs = c(0, 1/3, 2/3, 1)), labels = c('L', 'M', 'H'))
})
x1 = shapley |> 
 subset.ppp(select = c('Mag', 'SigV')) |>
 split.ppp(f = Vc) |>
 fv_ppplist(fn = markcorr, mc.cores = 1L)
names(x1)
names(x1$L)

x2 = nbfires |> 
  subset.ppp(select = c('fire.type', 'cause', 'ign.src')) |>
  na.omit.ppp() |> 
  split.ppp(f = 'fire.type')
dist_ppplist(x2, fn = .nncross, i = 'rrds', j = 'ltning', mc.cores = 1L)
dist_ppplist(x2, fn = .nncross, i = 'unknown', j = 'burn.no.perm', mc.cores = 1L)
}
\keyword{internal}
