% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_fv.R
\name{aggregate_fv}
\alias{aggregate_fv}
\title{Aggregate \link[spatstat.explore]{fv.object}s by Cluster}
\usage{
aggregate_fv(
  X,
  by = stop("must specify `by`"),
  f_aggr_ = pmean,
  mc.cores = getOption("mc.cores"),
  ...
)
}
\arguments{
\item{X}{a \link{groupedHyperframe},
containing one or more \link[spatstat.explore]{fv.object} column(s)}

\item{by}{one-sided \link[stats]{formula}, sample clustering.
Use only one-level hierarchy (e.g., \code{~patient} or \code{~image}).
Do not use multi-level hierarchy (e.g., \code{~patient/image})}

\item{f_aggr_}{see function \code{\link[=aggregate_by_]{aggregate_by_()}}}

\item{mc.cores}{\link[base]{integer} scalar, see function \link[parallel]{mclapply}.
Default is 1L on Windows, or \link[parallel]{detectCores} on Mac.
CRAN requires \code{mc.cores <= 2L} in examples.}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=aggregate_fv]{aggregate_fv()}} returns a \link[base]{data.frame}, with
aggregated information stored in \link[base]{matrix}-columns.

Note that \link[spatstat.geom]{hyperframe} does not support
\link[base]{matrix}-column (for good reasons!).
Therefore, function \code{\link[=aggregate_fv]{aggregate_fv()}} must return a \link[base]{data.frame},
instead of a \link[spatstat.geom]{hyperframe}.
}
\description{
Aggregate information in \link[spatstat.explore]{fv.object}s
by sample clustering.
}
\examples{
\dontshow{options(mc.cores = 1L)}
library(spatstat.data)
library(spatstat.geom)
flu$pattern[] = flu$pattern |> 
 lapply(FUN = `mark_name<-`, value = 'stain') # read ?flu carefully
r = seq.int(from = 0, to = 100, by = 5)
flu |>
 subset(stain == 'M2-M1') |>
 as.groupedHyperframe(group = ~ virustype/frameid) |>
 Gcross_(i = 'M1', j = 'M2', r = r, correction = 'best') |>
 aggregate_fv(by = ~ virustype)
}
\keyword{internal}
