% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{yield_parameters}
\alias{yield_parameters}
\title{Parameters for expected yields in Switzerland}
\format{
A data.frame with 4 rows and 3 variables:
\describe{
\item{intensity}{Management intensity}
\item{a}{Offset \emph{a} in t / ha}
\item{b}{Slope \emph{b} in t / ha / m}
}
}
\usage{
yield_parameters
}
\description{
The dataset contains the parameters \emph{a} and \emph{b} used to model the expected
gross dry matter yield (in t / ha) as a function of altitude (in m.a.s.l.) as
yield = a + b * altitude.
}
\details{
Lookup Table of expected yield as functions of height and management
intensity after table 1a in Olivier Huguenin et al.
}
\references{
\insertRef{huguenin2017GrundlagenDuengung}{growR}
}
\keyword{datasets}
