% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_growthmodel.R
\name{fit_growthmodel}
\alias{fit_growthmodel}
\title{Fit Nonlinear Parametric Growth Model}
\usage{
fit_growthmodel(FUN, p, time, y, lower = -Inf, upper = Inf,
  which = names(p), method = "Marq", transform = c("none", "log"),
  control = NULL, ...)
}
\arguments{
\item{FUN}{function of growth model to be fitted.}

\item{p}{named vector of start parameters and initial values of the growth model.}

\item{time}{vector of independent variable.}

\item{y}{vector of dependent variable (concentration of organisms).}

\item{lower}{lower bound of the parameter vector (optional).}

\item{upper}{upper bound of the parameter vector (optional).}

\item{which}{vector of parameter names that are to be fitted.}

\item{method}{character vector specifying the optimization algorithm (see \code{\link{modFit}}).}

\item{transform}{fit model to non-transformed or log-transformed data.}

\item{control}{A list of control parameters for the optimizers. See Details.}

\item{\dots}{additional parameters passed to the optimizer.}
}
\value{
object  with parameters of the fit.
}
\description{
Determine maximum growth rates by fitting nonlinear models.
}
\details{
This function calls \code{modFit} from package \pkg{FME}.
Syntax of control parameters and available options may differ, depending
on the optimizer used, except \code{control=list(trace=...)} that switches
  tracing on and off for all methods and is either \code{TRUE}, or \code{FALSE},
  or an integer value like 0, 1, 2, 3, depending on the optimizer.
}
\examples{

data(bactgrowth)
splitted.data <- multisplit(bactgrowth, c("strain", "conc", "replicate"))

## get one element either by index or by name
dat <- splitted.data[[1]]
dat <- splitted.data[["D:0:1"]]

p <- c(y0 = 0.01, mumax = 0.2, K = 0.1)

## unconstraied fitting
fit1 <- fit_growthmodel(FUN = grow_logistic, p = p, dat$time, dat$value)
coef(fit1)
summary(fit1)

## optional box-constraints
lower <- c(y0 = 1e-6, mumax = 0,   K = 0)
upper <- c(y0 = 0.05, mumax = 5,   K = 0.5)
fit1 <- fit_growthmodel(
  FUN = grow_logistic, p = p, dat$time, dat$value,
  lower = lower, upper = upper)

plot(fit1, log="y")

}
\seealso{
\code{\link{modFit}} about constrained fitting of models to data

Other fitting functions: \code{\link{all_easylinear}},
  \code{\link{all_growthmodels}},
  \code{\link{all_splines}}, \code{\link{fit_easylinear}},
  \code{\link{fit_spline}}
}
