% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lambdaChiMCAdjustment}
\alias{lambdaChiMCAdjustment}
\title{Monte Carlo based Group SLOPE tuning parameter correction}
\usage{
lambdaChiMCAdjustment(y, X, group_id, lambda, w, number_of_drawings = 5000L)
}
\arguments{
\item{y}{The response vector}

\item{X}{The model matrix}

\item{group_id}{A list obtained from \code{\link{getGroupID}}}

\item{lambda}{A vector containing the first s entries of lambda}

\item{w}{A vector of weights per group}

\item{number_of_drawings}{The number of iterations in the Monte Carlo procedure}
}
\description{
\code{lambdaChiMCAdjustment} approximates the variance of (2.25) in Brzyski et. al. (2015)
   via Monte Carlo, in order to adjust the lambda sequence for correlations in the  data.
}
\details{
The adjustment is computed for the (s+1)st coefficient of lambda, assuming 
that the first s coefficients are known. It is required that rank(X) is greater than the 
sum of the number of elements in any s groups.
}
\references{
D. Brzyski, W. Su, M. Bogdan (2015), \emph{Group SLOPE -- adaptive selection of groups of predictors}, \url{http://arxiv.org/abs/1511.09078}

\url{http://www.alexejgossmann.com/grpSLOPE/Lambda/}
}

