% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkeep.R
\name{wkeep}
\alias{wkeep}
\title{Keep part of vector or matrix}
\usage{
wkeep(x, l, opt = "centered")
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix.}

\item{l}{either a positive integer value, specifying the length to extract
from the input *vector* \code{x}, or a vector of length 2, indicating the
submatrix to extract from the *matrix* \code{x}. See the examples.}

\item{opt}{One of:
\describe{
  \item{character string}{matched against \code{c("centered", "left",
  "right")}, indicating the location of the *vector* \code{x} to extract}
  \item{positive integer}{starting index of the input *vector* \code{x}}
  \item{two-element vector}{starting row and columns from the *matrix*
  \code{x}}
}
See the examples. Default: "centered".}
}
\value{
extracted vector or matrix
}
\description{
Extract elements from a vector or matrix.
}
\examples{
## create a vector
x <- 1:10
## Extract a vector of length 6 from the central part of x.
y <- wkeep(x, 6, 'c')

## Extract two vectors of length 6, one from the left part of x, and the
## other from the right part of x.
y <- wkeep(x, 6, 'l')
y <- wkeep(x, 6, 'r')

## Create a 5-by-5 matrix.
x <- matrix(round(runif(25, 0, 25)), 5, 5)

## Extract a 3-by-2 matrix from the center of x
y <- wkeep(x, c(3, 2))

## Extract from x the 2-by-4 submatrix starting at x[3, 1].
y <- wkeep(x, c(2, 4), c(3, 1))

}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
