% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{df.residual.gsl_nls}
\alias{df.residual.gsl_nls}
\title{Residual degrees-of-freedom}
\usage{
\method{df.residual}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Integer residual degrees-of-freedom similar to \code{\link[stats]{df.residual}}.
}
\description{
Returns the residual degrees-of-freedom from a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

df.residual(obj)
}
\seealso{
\code{\link[stats]{df.residual}}
}
