% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_global}
\alias{plot_global}
\title{Plot all chromosomes of a population}
\usage{
plot_global(dat, sb = NULL, baf = FALSE, cex = 0.2, ...)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf"
and "rratio" and two vectors "chr" and "pos".}

\item{sb}{Synteny blocks. Data frame with columns start1, start2,
end1, end2, chr1 and chr2.}

\item{baf}{Logical, if B-Allele frequency should be plotted.}

\item{cex}{Size of dots.}

\item{...}{arguments are forwarded to \code{plot()}.}
}
\description{
Plot all chromosomes of a sample.
The one subgenome is plotted on top, the other at the bottom.
If available, the synteny plots can be plotted between them.
Deletions and duplications are indicated by different colors.
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:100)][-(30000:30100)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
data("synteny_blocks", package = "brassicaData", envir = environment())
plot_global(dat, sb = synteny_blocks)
}
}

