% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_adiabatic_lapse_rate_from_CT}
\alias{gsw_adiabatic_lapse_rate_from_CT}
\title{Adiabatic lapse rate from Conservative Temperature}
\usage{
gsw_adiabatic_lapse_rate_from_CT(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
adiabatic lapse rate (note unconventional unit) [ K/Pa ]
}
\description{
Note that the unit is K/Pa, i.e. 1e-4 times K/dbar.
}
\examples{
gsw_adiabatic_lapse_rate_from_CT(34.7118, 28.7856, 10) # 2.40199646230069e-8
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_adiabatic_lapse_rate_from_CT.html}
}

