% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SR_from_SP}
\alias{gsw_SR_from_SP}
\title{Calculate Reference Salinity from Practical Salinity}
\usage{
gsw_SR_from_SP(SP)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}
}
\value{
Reference Salinity [ g/kg ]
}
\description{
Calculate Reference Salinity from Practical Salinity
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SP <- c(34.5487, 34.7275, 34.8605, 34.6810, 34.5680, 34.5600)
SR <- gsw_SR_from_SP(SP)
expect_equal(SR, c(34.711611927085727, 34.891255045714303, 35.024882197714305,
                   34.844535778285724, 34.731002934857159, 34.722965211428587))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SR_from_SP.html}
}
\seealso{
Other things related to salinity: \code{\link{gsw_C_from_SP}},
  \code{\link{gsw_SA_from_SP_Baltic}},
  \code{\link{gsw_SA_from_SP}},
  \code{\link{gsw_SA_from_Sstar}},
  \code{\link{gsw_SP_from_C}},
  \code{\link{gsw_SP_from_SA}},
  \code{\link{gsw_SP_from_SK}},
  \code{\link{gsw_SP_from_SR}},
  \code{\link{gsw_SP_from_Sstar}},
  \code{\link{gsw_Sstar_from_SA}},
  \code{\link{gsw_Sstar_from_SP}},
  \code{\link{gsw_deltaSA_from_SP}}
}
