% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_pot_enthalpy_ice}
\alias{gsw_pt_from_pot_enthalpy_ice}
\title{Potential Temperature from Potential Enthalpy of Ice}
\usage{
gsw_pt_from_pot_enthalpy_ice(pot_enthalpy_ice)
}
\arguments{
\item{pot_enthalpy_ice}{potential enthalpy of ice [ J/kg ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential Temperature from Potential Enthalpy of Ice
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
pot_enthalpy_ice <- c(-3.5544e5, -3.6033e5, -3.5830e5, -3.5589e5, -3.4948e5, -3.4027e5)
pt <- gsw_pt_from_pot_enthalpy_ice(pot_enthalpy_ice)
expect_equal(pt, c(-10.733087588125384, -13.167397822300588, -12.154205899172704,
                 -10.956202704066083, -7.794963180206421, -3.314905214262531))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_pot_enthalpy_ice.html}
}
\seealso{
Other things related to enthalpy: \code{\link{gsw_CT_from_enthalpy}},
  \code{\link{gsw_dynamic_enthalpy}},
  \code{\link{gsw_enthalpy_CT_exact}},
  \code{\link{gsw_enthalpy_diff}},
  \code{\link{gsw_enthalpy_first_derivatives_CT_exact}},
  \code{\link{gsw_enthalpy_first_derivatives}},
  \code{\link{gsw_enthalpy_ice}},
  \code{\link{gsw_enthalpy_t_exact}},
  \code{\link{gsw_enthalpy}},
  \code{\link{gsw_frazil_properties_potential_poly}},
  \code{\link{gsw_frazil_properties_potential}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice_poly}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice}},
  \code{\link{gsw_pot_enthalpy_ice_freezing_poly}},
  \code{\link{gsw_pot_enthalpy_ice_freezing}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice_poly}},
  \code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_specvol_first_derivatives}}
}
