% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_spanner}
\alias{tab_spanner}
\title{Add a spanner column label}
\usage{
tab_spanner(data, label, columns, gather = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{label}{The text to use for the spanner column label.}

\item{columns}{The columns to be components of the spanner heading.}

\item{gather}{An option to move the specified \code{columns} such that they are
unified under the spanner column label. Ordering of the moved-into-place
columns will be preserved in all cases.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Set a spanner column label by mapping it to columns already in the table.
This label is placed above one or more column labels, spanning the width of
those columns and column labels.
}
\section{Figures}{

\if{html}{\figure{man_tab_spanner_1.png}{options: width=100\%}}
}

\section{Function ID}{

2-2
}

\examples{
# Use `gtcars` to create a gt table;
# Group several columns related to car
# performance under a spanner column
# with the label `performance`
tab_1 <-
  gtcars \%>\%
  dplyr::select(
    -mfr, -trim, bdy_style, drivetrain,
    -drivetrain, -trsmn, -ctry_origin
  ) \%>\%
  dplyr::slice(1:8) \%>\%
  gt(rowname_col = "model") \%>\%
  tab_spanner(
    label = "performance",
    columns = vars(
      hp, hp_rpm, trq, trq_rpm,
      mpg_c, mpg_h)
  )

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
