% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_spelled_num}
\alias{vec_fmt_spelled_num}
\title{Format a vector as spelled-out numbers}
\usage{
vec_fmt_spelled_num(
  x,
  pattern = "{x}",
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{\emph{The input vector}

\code{vector(numeric|integer)} // \strong{required}

This is the input vector that will undergo transformation to a character
vector of the same length. Values within the vector will be formatted.}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according to the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported.}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can transform those to numbers that are
spelled out. Any values from \code{0} to \code{100} can be spelled out according to the
specified locale. For example, the value \code{23} will be rendered as
\code{"twenty-three"} if the locale is an English-language one (or, not provided
at all); should a Swedish locale be provided (e.g., \code{"sv"}), the output will
instead be \code{"tjugotre"}.
}
\section{Supported locales}{


The following 80 locales are supported in the \code{locale} argument of
\code{vec_fmt_spelled_num()}: \code{"af"} (Afrikaans), \code{"ak"} (Akan), \code{"am"} (Amharic),
\code{"ar"} (Arabic), \code{"az"} (Azerbaijani), \code{"be"} (Belarusian), \code{"bg"}
(Bulgarian), \code{"bs"} (Bosnian), \code{"ca"} (Catalan), \code{"ccp"} (Chakma), \code{"chr"}
(Cherokee), \code{"cs"} (Czech), \code{"cy"} (Welsh), \code{"da"} (Danish), \code{"de"} (German),
\code{"de-CH"} (German (Switzerland)), \code{"ee"} (Ewe), \code{"el"} (Greek), \code{"en"}
(English), \code{"eo"} (Esperanto), \code{"es"} (Spanish), \code{"et"} (Estonian), \code{"fa"}
(Persian), \code{"ff"} (Fulah), \code{"fi"} (Finnish), \code{"fil"} (Filipino), \code{"fo"}
(Faroese), \code{"fr"} (French), \code{"fr-BE"} (French (Belgium)), \code{"fr-CH"} (French
(Switzerland)), \code{"ga"} (Irish), \code{"he"} (Hebrew), \code{"hi"} (Hindi), \code{"hr"}
(Croatian), \code{"hu"} (Hungarian), \code{"hy"} (Armenian), \code{"id"} (Indonesian),
\code{"is"} (Icelandic), \code{"it"} (Italian), \code{"ja"} (Japanese), \code{"ka"} (Georgian),
\code{"kk"} (Kazakh), \code{"kl"} (Kalaallisut), \code{"km"} (Khmer), \code{"ko"} (Korean),
\code{"ky"} (Kyrgyz), \code{"lb"} (Luxembourgish), \code{"lo"} (Lao), \code{"lrc"} (Northern
Luri), \code{"lt"} (Lithuanian), \code{"lv"} (Latvian), \code{"mk"} (Macedonian), \code{"ms"}
(Malay), \code{"mt"} (Maltese), \code{"my"} (Burmese), \code{"ne"} (Nepali), \code{"nl"} (Dutch),
\code{"nn"} (Norwegian Nynorsk), \code{"no"} (Norwegian), \code{"pl"} (Polish), \code{"pt"}
(Portuguese), \code{"qu"} (Quechua), \code{"ro"} (Romanian), \code{"ru"} (Russian), \code{"se"}
(Northern Sami), \code{"sk"} (Slovak), \code{"sl"} (Slovenian), \code{"sq"} (Albanian),
\code{"sr"} (Serbian), \code{"sr-Latn"} (Serbian (Latin)), \code{"su"} (Sundanese), \code{"sv"}
(Swedish), \code{"sw"} (Swahili), \code{"ta"} (Tamil), \code{"th"} (Thai), \code{"tr"} (Turkish),
\code{"uk"} (Ukrainian), \code{"vi"} (Vietnamese), \code{"yue"} (Cantonese), and \code{"zh"}
(Chinese).
}

\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(1, 8, 23, 76, 0, -5, 200, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_spelled_num()} will create a character vector with values
rendered as spelled-out numbers. Any \code{NA} values remain as \code{NA} values. The
rendering context will be autodetected unless specified in the \code{output}
argument (here, it is of the \code{"plain"} output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "one"     "eight"     "twenty-three"  "seventy-six"  "zero"
#> [6] "-5"      "200"       "NA"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and let \strong{gt} obtain a locale-specific set of spelled numbers:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals, locale = "af")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "een"     "agt"     "drie-en-twintig"     "ses-en-sewentig"
#> [5] "nul"     "-5"      "200"                 "NA"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals, pattern = "\{x\}.")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "one."     "eight."     "twenty-three."  "seventy-six."  "zero."
#> [6] "-5."      "200."       "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-11
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_spelled_num]{fmt_spelled_num()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_index}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
